#pragma once

#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include <fstream.>
#include <string>
#include "XeDebug.h" //MATTIE: make XeDebug available

using namespace std;

#define DEVICE_NAND_FLASH 0
#define DEVICE_MEMORY_UNIT0 1
#define DEVICE_MEMORY_UNIT1 2
#define DEVICE_MEMORY_ONBOARD 3
#define DEVICE_CDROM0 4
#define DEVICE_HARDISK0_PART1 5
#define DEVICE_HARDISK0_SYSPART 6
#define DEVICE_USB0 7
#define DEVICE_USB1 8
#define DEVICE_USB2 9
#define DEVICE_TEST 10

/*
#define DEVICE_NAND_FLASH 0
#define DEVICE_MEMORY_UNIT0 1
#define DEVICE_MEMORY_UNIT1 2
#define DEVICE_CDROM0 3
#define DEVICE_HARDISK0_PART0 4
#define DEVICE_HARDISK0_PART1 5
#define DEVICE_HARDISK0_PART2 6
#define DEVICE_HARDISK0_PART3 7
#define DEVICE_USB0 8
#define DEVICE_USB1 9
#define DEVICE_USB2 10
#define DEVICE_HARDISK0_SYSPART 11
*/

typedef unsigned int    u32;

typedef struct _STRING {
    USHORT Length;
    USHORT MaximumLength;
    PCHAR Buffer;
} STRING;

extern "C" int __stdcall ObCreateSymbolicLink( STRING*, STRING*);
extern "C" int __stdcall ObDeleteSymbolicLink( STRING* );
extern "C" UINT32 __stdcall XexGetModuleHandle(char* module, PVOID hand); //ie XexGetModuleHandle("xam.xex", &hand);// uint32 hand, returns 0 on success
extern "C" UINT32 __stdcall XexGetProcedureAddress(UINT32 hand ,UINT32, PVOID);// ie XexGetProcedureAddress(hand ,0x50, &addr); // uint32 addr, returns 0 on success

void debugLog(const char* output);
void ftpLog(const char* output);
HRESULT Mount( int Device, char* MountPoint );
HRESULT Unmount( char* MountPoint );
int DriveMounted(string path);

u32 resolveFunct(char* modname, u32 ord);
u32 mountCon(CHAR* szDrive, CHAR* szDevice, CHAR* szPath);
u32 unmountCon(CHAR* szDrive, CHAR* szDevice, CHAR* szPath);
int GetGamerTag(int playerIndex,char* ret);
long GetGamerPoints(int playerIndex);
bool IsUserSignedIn(int playerIndex);
bool SaveTextureToPNGFile(IDirect3DTexture9* pTexture, string pLocation);
int GetGamerPicture(int playerIndex,PBYTE ret,BOOL small,DWORD pitch,DWORD height);
bool InitNetwork();
// void DebugMsg(const char *format, ...) ; //MATTIE: replaced by XeDebug version
void FTPMsg(const char *format, ...) ;

